
import UIKit

class LoginController: UIViewController {
    
    let logoImageView: UIImageView = {
        let iv = UIImageView()
        iv.contentMode = .scaleAspectFit
        iv.clipsToBounds = true
        iv.image = #imageLiteral(resourceName: "logo")
        return iv
    }()
    
    lazy var passwordContainerView: UIView = {
        let view = UIView()
        return view.textContainerView(view: view, #imageLiteral(resourceName: "Lock"), passwordTextField)
    }()

    
    lazy var passwordTextField: UITextField = {
        let tf = UITextField()
        return tf.textField(withPlaceolder: "Password", isSecureTextEntry: true)
    }()
    
    let loginButton: UIButton = {
        let button = UIButton(type: .system)
        button.setTitle("LOG IN", for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 18)
        button.setTitleColor(UIColor.mainBlue(), for: .normal)
        button.backgroundColor = .white
        button.addTarget(self, action: #selector(handleLogin), for: .touchUpInside)
        button.layer.cornerRadius = 5
        return button
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        configureViewComponents()
    }
    
    @objc func handleLogin() {
        guard let password = passwordTextField.text else { return }
        
        if password == "vgeco" {
            self.presentingViewController?.presentingViewController?.dismiss(animated: true, completion: nil)
            self.dismiss(animated: true, completion: nil)
        }
        
        else {
            errorPopup()
        }
    }
    
    var addedButton = UIButton()
    let blurEffectView = UIVisualEffectView(effect: UIBlurEffect(style: UIBlurEffect.Style.light))
    var removeButton = UIButton()
    let addedLabel = UILabel()
    let addedImage = UIImageView()
    
    func errorPopup() {
        blurEffectView.frame = view.bounds
        blurEffectView.autoresizingMask = [.flexibleWidth, .flexibleHeight]
        
        addedButton.frame = CGRect(x: (screenWidth/2)-130, y: 360, width: 260, height: 100)
        addedButton.layer.cornerRadius = 15;
        addedButton.clipsToBounds = true
        addedButton.backgroundColor = UIColor.black.withAlphaComponent(0.8)
        addedButton.setTitle("", for: .normal)
        
        addedLabel.textColor = .white
        addedLabel.text = "     Invalid Password"
        addedLabel.frame = CGRect(x: (screenWidth/2)-110, y: 360, width: 230, height: 100)

        addedImage.frame = CGRect(x: (screenWidth/2)+65, y: 385, width: 50, height: 50)
        addedImage.image = UIImage(named:"Cross")
        
        removeButton.addTarget(self, action: #selector(popupRemove), for: .touchUpInside)
        removeButton.frame = CGRect(x: 0, y: 0, width: screenWidth, height: screenHeight)
        
        UIView.transition(with: self.view, duration: 0.25, options: [.transitionCrossDissolve], animations: {
            self.view.addSubview(self.blurEffectView)
            self.view.addSubview(self.addedButton)
            self.view.addSubview(self.removeButton)
            self.view.addSubview(self.addedLabel)
            self.view.addSubview(self.addedImage)
        }, completion: nil)
    }
    
    //MARK:- Remove Error Handler
    
    @objc func popupRemove(sender: UIButton) {
        UIView.transition(with: self.view, duration: 0.25, options: [.transitionCrossDissolve], animations: {
            self.addedButton.removeFromSuperview()
            self.blurEffectView.removeFromSuperview()
            self.removeButton.removeFromSuperview()
            self.addedLabel.removeFromSuperview()
            self.addedImage.removeFromSuperview()
        }, completion: nil)
    }

    
    func configureViewComponents() {
        view.backgroundColor = UIColor.mainBlue()
        navigationController?.navigationBar.isHidden = true
        navigationController?.navigationBar.barStyle = .black
        view.addSubview(logoImageView)
        logoImageView.anchor(top: view.topAnchor, left: nil, bottom: nil, right: nil, paddingTop: 135, paddingLeft: 0, paddingBottom: 0, paddingRight: 0, width: 150, height: 150)
        logoImageView.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true
        
        view.addSubview(passwordContainerView)
        passwordContainerView.anchor(top: logoImageView.bottomAnchor, left: view.leftAnchor, bottom: nil, right: view.rightAnchor, paddingTop: 60, paddingLeft: 32, paddingBottom: 0, paddingRight: 32, width: 0, height: 50)
        
        view.addSubview(loginButton)
        loginButton.anchor(top: passwordContainerView.bottomAnchor, left: view.leftAnchor, bottom: nil, right: view.rightAnchor, paddingTop: 12, paddingLeft: 32, paddingBottom: 0, paddingRight: 32, width: 0, height: 50)
    }
    
}
